import requests
import zipfile
import io
import os
import shutil

# GitHub repository information
OWNER = "Leaflet"
REPO = "Leaflet"

# The desired final name of the extracted folder
final_folder_name = "leaflet"

# GitHub API URL to get information about the latest release
api_url = f"https://api.github.com/repos/{OWNER}/{REPO}/releases/latest"

try:
    print(f"Meklējam informāciju par jaunāko versiju no: {api_url}")
    
    # 1. Get latest release information from GitHub API
    api_response = requests.get(api_url)
    api_response.raise_for_status()  # Raise an exception for bad status codes (4xx or 5xx)
    
    release_data = api_response.json()
    zip_file_url = None
    latest_version = release_data.get('tag_name', 'Nezināma versija')

    # Find the download URL for 'leaflet.zip' in the assets
    for asset in release_data.get('assets', []):
        if asset.get('name') == 'leaflet.zip':
            zip_file_url = asset.get('browser_download_url')
            break
            
    if not zip_file_url:
        print("Kļūda: Jaunākajā laidienā nevarēja atrast 'leaflet.zip' failu.")
        exit()

    print(f"Atrasta jaunākā versija: {latest_version}.")
    print(f"Lejupielādējam no: {zip_file_url}")

    # 2. Download the zip file
    response = requests.get(zip_file_url)
    response.raise_for_status()

    print("Lejupielāde veiksmīga. Sākam atarhivēšanu.")
    zip_file_bytes = io.BytesIO(response.content)

    original_folder_name = None
    # 3. Extract and find the root folder name
    with zipfile.ZipFile(zip_file_bytes, 'r') as thezip:
        # Assuming the first file in the list gives us the root directory name
        if thezip.namelist():
            original_folder_name = thezip.namelist()[0].split('/')[0]
        else:
            print("Kļūda: Lejupielādētais ZIP arhīvs ir tukšs.")
            exit()

        thezip.extractall()
    
    print(f"Fails atarhivēts. Izveidota mape '{original_folder_name}'.")

    # 4. Rename the extracted folder
    # If a folder with the final name already exists, remove it first
    if os.path.exists(final_folder_name):
        print(f"Mape '{final_folder_name}' jau eksistē. Tā tiks aizvietota.")
        shutil.rmtree(final_folder_name)
    
    # Rename the original folder to the final folder name
    os.rename(original_folder_name, final_folder_name)
    print(f"Mape '{original_folder_name}' ir veiksmīgi pārsaukta par '{final_folder_name}'.")


except requests.exceptions.RequestException as e:
    print(f"Kļūda, sazinoties ar GitHub API vai lejupielādējot failu: {e}")
except Exception as e:
    print(f"Radās neparedzēta kļūda: {e}")